/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.shop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.CharacterStrings;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.Courier;
import com.megacrit.cardcrawl.relics.OldCoin;
import com.megacrit.cardcrawl.relics.SmilingMask;
import com.megacrit.cardcrawl.shop.OnSaleTag;
import com.megacrit.cardcrawl.shop.StorePotion;
import com.megacrit.cardcrawl.shop.StoreRelic;
import com.megacrit.cardcrawl.ui.DialogWord;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.FastCardObtainEffect;
import com.megacrit.cardcrawl.vfx.FloatyEffect;
import com.megacrit.cardcrawl.vfx.ShopSpeechBubble;
import com.megacrit.cardcrawl.vfx.SpeechTextEffect;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShopScreen {
    private static final Logger logger = LogManager.getLogger(ShopScreen.class.getName());
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Shop Tip");
    public static final String[] MSG = ShopScreen.tutorialStrings.TEXT;
    public static final String[] LABEL = ShopScreen.tutorialStrings.LABEL;
    private static final CharacterStrings characterStrings = CardCrawlGame.languagePack.getCharacterString("Shop Screen");
    public static final String[] NAMES = ShopScreen.characterStrings.NAMES;
    public static final String[] TEXT = ShopScreen.characterStrings.TEXT;
    public boolean isActive = true;
    private Texture rugImg;
    private float rugY = Settings.HEIGHT;
    private static final float RUG_SPEED = 5.0f;
    private ArrayList<AbstractCard> coloredCards = new ArrayList();
    private ArrayList<AbstractCard> colorlessCards = new ArrayList();
    private static final float DRAW_START_X = (float)Settings.WIDTH * 0.16f;
    private static final int NUM_CARDS_PER_LINE = 5;
    private static final float CARD_PRICE_JITTER = 0.1f;
    private static final float TOP_ROW_Y = 730.0f * Settings.scale;
    private static final float BOTTOM_ROW_Y = 307.0f * Settings.scale;
    private float speechTimer = 0.0f;
    private static final float MIN_IDLE_MSG_TIME = 40.0f;
    private static final float MAX_IDLE_MSG_TIME = 60.0f;
    private static final float SPEECH_DURATION = 4.0f;
    private static final float SPEECH_TEXT_R_X = 164.0f * Settings.scale;
    private static final float SPEECH_TEXT_L_X = -166.0f * Settings.scale;
    private static final float SPEECH_TEXT_Y = 126.0f * Settings.scale;
    private ShopSpeechBubble speechBubble = null;
    private SpeechTextEffect dialogTextEffect = null;
    private static final String WELCOME_MSG = NAMES[0];
    private ArrayList<String> idleMessages = new ArrayList();
    private boolean saidWelcome = false;
    private boolean somethingHovered = false;
    private ArrayList<StoreRelic> relics = new ArrayList();
    private static final float RELIC_PRICE_JITTER = 0.05f;
    private ArrayList<StorePotion> potions = new ArrayList();
    private static final float POTION_PRICE_JITTER = 0.05f;
    public boolean purgeAvailable = false;
    public static int purgeCost = 75;
    public static int actualPurgeCost = 75;
    private static final int PURGE_COST_RAMP = 25;
    private boolean purgeHovered = false;
    private float purgeCardX;
    private float purgeCardY;
    private float purgeCardScale = 1.0f;
    private FloatyEffect f_effect = new FloatyEffect(20.0f, 0.1f);
    private float handTimer = 1.0f;
    private float handX = (float)Settings.WIDTH / 2.0f;
    private float handY = Settings.HEIGHT;
    private float handTargetX = 0.0f;
    private float handTargetY = Settings.HEIGHT;
    private Texture handImg;
    private static final float HAND_SPEED = 6.0f;
    private static float HAND_W;
    private static float HAND_H;
    private float notHoveredTimer = 0.0f;
    private static final float GOLD_IMG_WIDTH;
    private static final float COLORLESS_PRICE_BUMP = 1.3f;
    private OnSaleTag saleTag;
    private static final float GOLD_IMG_OFFSET_X;
    private static final float GOLD_IMG_OFFSET_Y;
    private static final float PRICE_TEXT_OFFSET_X;
    private static final float PRICE_TEXT_OFFSET_Y;

    public void init(ArrayList<AbstractCard> coloredCards, ArrayList<AbstractCard> colorlessCards) {
        Collections.addAll(this.idleMessages, TEXT);
        this.rugImg = ImageMaster.loadImage("images/npcs/rug.png");
        this.handImg = ImageMaster.loadImage("images/npcs/merchantHand.png");
        HAND_W = (float)this.handImg.getWidth() * Settings.scale;
        HAND_H = (float)this.handImg.getHeight() * Settings.scale;
        this.coloredCards.clear();
        this.colorlessCards.clear();
        this.coloredCards = coloredCards;
        this.colorlessCards = colorlessCards;
        this.initCards();
        this.initRelics();
        this.initPotions();
        this.purgeAvailable = true;
        this.purgeCardY = -1000.0f;
        this.purgeCardX = 1400.0f * Settings.scale;
        this.purgeCardScale = 0.7f;
        actualPurgeCost = purgeCost;
        if (AbstractDungeon.player.hasRelic("The Courier")) {
            this.applyDiscount(0.8f);
        }
        if (AbstractDungeon.player.hasRelic("Membership Card")) {
            this.applyDiscount(0.8f);
        }
        if (DailyMods.mods.get("Vintage").booleanValue()) {
            this.applyDiscount(1.25f);
        }
        if (AbstractDungeon.player.hasRelic("Smiling Mask")) {
            actualPurgeCost = 50;
        }
    }

    public static void resetPurgeCost() {
        purgeCost = 75;
        actualPurgeCost = 75;
    }

    private void initCards() {
        float tmpPrice;
        int i;
        int tmp = (int)((float)Settings.WIDTH - DRAW_START_X * 2.0f - AbstractCard.IMG_WIDTH_S * 5.0f) / 4;
        float padX = (int)((float)tmp + AbstractCard.IMG_WIDTH_S);
        for (i = 0; i < this.coloredCards.size(); ++i) {
            tmpPrice = (float)AbstractCard.getPrice(this.coloredCards.get((int)i).rarity) * AbstractDungeon.merchantRng.random(0.9f, 1.1f);
            this.coloredCards.get((int)i).price = (int)tmpPrice;
            this.coloredCards.get((int)i).current_x = Settings.WIDTH / 2;
            this.coloredCards.get((int)i).target_x = DRAW_START_X + AbstractCard.IMG_WIDTH_S / 2.0f + padX * (float)i;
        }
        for (i = 0; i < this.colorlessCards.size(); ++i) {
            tmpPrice = (float)AbstractCard.getPrice(this.colorlessCards.get((int)i).rarity) * AbstractDungeon.merchantRng.random(0.9f, 1.1f);
            this.colorlessCards.get((int)i).price = (int)(tmpPrice *= 1.3f);
            this.colorlessCards.get((int)i).current_x = Settings.WIDTH / 2;
            this.colorlessCards.get((int)i).target_x = DRAW_START_X + AbstractCard.IMG_WIDTH_S / 2.0f + padX * (float)i;
        }
        AbstractCard saleCard = this.coloredCards.get(AbstractDungeon.merchantRng.random(0, 4));
        saleCard.price /= 2;
        this.saleTag = new OnSaleTag(saleCard);
        this.setStartingCardPositions();
    }

    public static void purgeCard() {
        AbstractDungeon.player.loseGold(actualPurgeCost);
        CardCrawlGame.sound.play("SHOP_PURCHASE", 0.1f);
        actualPurgeCost = purgeCost += 25;
        if (AbstractDungeon.player.hasRelic("Smiling Mask")) {
            actualPurgeCost = 50;
        } else if (AbstractDungeon.player.hasRelic("The Courier") && AbstractDungeon.player.hasRelic("Membership Card")) {
            actualPurgeCost = MathUtils.round((float)purgeCost * 0.8f * 0.8f);
        } else if (AbstractDungeon.player.hasRelic("The Courier")) {
            actualPurgeCost = MathUtils.round((float)purgeCost * 0.8f);
        } else if (AbstractDungeon.player.hasRelic("Membership Card")) {
            actualPurgeCost = MathUtils.round((float)purgeCost * 0.8f);
        }
    }

    public void updatePurge() {
        if (!AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            ShopScreen.purgeCard();
            for (AbstractCard card : AbstractDungeon.gridSelectScreen.selectedCards) {
                CardCrawlGame.metricData.items_purged.add(card.cardID);
                AbstractDungeon.topLevelEffects.add(new PurgeCardEffect(card, Settings.WIDTH / 2, Settings.HEIGHT / 2));
                AbstractDungeon.player.masterDeck.removeCard(card);
            }
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            AbstractDungeon.shopScreen.purgeAvailable = false;
        }
    }

    public static String getCantBuyMsg() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(NAMES[1]);
        list.add(NAMES[2]);
        list.add(NAMES[3]);
        list.add(NAMES[4]);
        list.add(NAMES[5]);
        list.add(NAMES[6]);
        return (String)list.get(MathUtils.random(list.size() - 1));
    }

    public static String getBuyMsg() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(NAMES[7]);
        list.add(NAMES[8]);
        list.add(NAMES[9]);
        list.add(NAMES[10]);
        list.add(NAMES[11]);
        return (String)list.get(MathUtils.random(list.size() - 1));
    }

    public void applyDiscount(float multiplier) {
        for (StoreRelic r : this.relics) {
            r.price = MathUtils.round((float)r.price * multiplier);
        }
        for (StorePotion p : this.potions) {
            p.price = MathUtils.round((float)p.price * multiplier);
        }
        for (AbstractCard c : this.coloredCards) {
            c.price = MathUtils.round((float)c.price * multiplier);
        }
        for (AbstractCard c : this.colorlessCards) {
            c.price = MathUtils.round((float)c.price * multiplier);
        }
        actualPurgeCost = AbstractDungeon.player.hasRelic("Smiling Mask") ? 50 : MathUtils.round((float)purgeCost * multiplier);
    }

    private void initRelics() {
        this.relics.clear();
        this.relics = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            AbstractRelic tempRelic = AbstractDungeon.returnRandomRelicEnd(ShopScreen.rollRelicTier());
            while (tempRelic instanceof OldCoin || tempRelic instanceof SmilingMask || tempRelic instanceof Courier) {
                tempRelic = AbstractDungeon.returnRandomRelicEnd(ShopScreen.rollRelicTier());
            }
            StoreRelic relic = new StoreRelic(tempRelic, i, this);
            if (!Settings.isDailyRun) {
                relic.price = MathUtils.round((float)relic.price * AbstractDungeon.merchantRng.random(0.95f, 1.05f));
            }
            this.relics.add(relic);
        }
    }

    private void initPotions() {
        this.potions.clear();
        this.potions = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            StorePotion potion = new StorePotion(AbstractDungeon.returnRandomPotion(15), i, this);
            if (!Settings.isDailyRun) {
                potion.price = MathUtils.round((float)potion.price * AbstractDungeon.merchantRng.random(0.95f, 1.05f));
            }
            this.potions.add(potion);
        }
    }

    public void getNewPrice(StoreRelic r) {
        int retVal = r.price;
        if (!Settings.isDailyRun) {
            retVal = MathUtils.round((float)retVal * AbstractDungeon.merchantRng.random(0.95f, 1.05f));
        }
        if (AbstractDungeon.player.hasRelic("The Courier")) {
            this.applyDiscountToRelic(retVal, 0.8f);
        }
        if (AbstractDungeon.player.hasRelic("Membership Card")) {
            this.applyDiscountToRelic(retVal, 0.8f);
        }
        if (DailyMods.mods.get("Vintage").booleanValue()) {
            this.applyDiscountToRelic(retVal, 1.25f);
        }
        r.price = retVal;
    }

    public void getNewPrice(StorePotion r) {
        int retVal = r.price;
        if (!Settings.isDailyRun) {
            retVal = MathUtils.round((float)retVal * AbstractDungeon.merchantRng.random(0.95f, 1.05f));
        }
        if (AbstractDungeon.player.hasRelic("The Courier")) {
            this.applyDiscountToRelic(retVal, 0.8f);
        }
        if (AbstractDungeon.player.hasRelic("Membership Card")) {
            this.applyDiscountToRelic(retVal, 0.8f);
        }
        if (DailyMods.mods.get("Vintage").booleanValue()) {
            this.applyDiscountToRelic(retVal, 1.25f);
        }
        r.price = retVal;
    }

    private int applyDiscountToRelic(int price, float multiplier) {
        return MathUtils.round((float)price * multiplier);
    }

    public static AbstractRelic.RelicTier rollRelicTier() {
        int roll = AbstractDungeon.merchantRng.random(99);
        logger.info("ROLL " + roll);
        if (roll < 5) {
            return AbstractRelic.RelicTier.SHOP;
        }
        if (roll < 51) {
            return AbstractRelic.RelicTier.UNCOMMON;
        }
        if (roll < 83) {
            return AbstractRelic.RelicTier.COMMON;
        }
        return AbstractRelic.RelicTier.RARE;
    }

    private void setStartingCardPositions() {
        int i;
        int tmp = (int)((float)Settings.WIDTH - DRAW_START_X * 2.0f - AbstractCard.IMG_WIDTH_S * 5.0f) / 4;
        float padX = (float)((int)((float)tmp + AbstractCard.IMG_WIDTH_S)) + 10.0f * Settings.scale;
        for (i = 0; i < this.coloredCards.size(); ++i) {
            this.coloredCards.get(i).updateHoverLogic();
            this.coloredCards.get((int)i).targetDrawScale = 0.75f;
            this.coloredCards.get((int)i).current_x = DRAW_START_X + AbstractCard.IMG_WIDTH_S / 2.0f + padX * (float)i;
            this.coloredCards.get((int)i).target_x = DRAW_START_X + AbstractCard.IMG_WIDTH_S / 2.0f + padX * (float)i;
            this.coloredCards.get((int)i).target_y = 9999.0f * Settings.scale;
            this.coloredCards.get((int)i).current_y = 9999.0f * Settings.scale;
        }
        for (i = 0; i < this.colorlessCards.size(); ++i) {
            this.colorlessCards.get(i).updateHoverLogic();
            this.colorlessCards.get((int)i).targetDrawScale = 0.75f;
            this.colorlessCards.get((int)i).current_x = DRAW_START_X + AbstractCard.IMG_WIDTH_S / 2.0f + padX * (float)i;
            this.colorlessCards.get((int)i).target_x = DRAW_START_X + AbstractCard.IMG_WIDTH_S / 2.0f + padX * (float)i;
            this.colorlessCards.get((int)i).target_y = 9999.0f * Settings.scale;
            this.colorlessCards.get((int)i).current_y = 9999.0f * Settings.scale;
        }
    }

    public void open() {
        CardCrawlGame.sound.play("SHOP_OPEN");
        this.setStartingCardPositions();
        this.purgeCardY = -1000.0f;
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.SHOP;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.cancelButton.show(NAMES[12]);
        for (StoreRelic r : this.relics) {
            r.hide();
        }
        for (StorePotion p : this.potions) {
            p.hide();
        }
        this.rugY = Settings.HEIGHT;
        this.handX = (float)Settings.WIDTH / 2.0f;
        this.handY = Settings.HEIGHT;
        this.handTargetX = this.handX;
        this.handTargetY = this.handY;
        this.handTimer = 1.0f;
        this.speechTimer = 1.5f;
        this.speechBubble = null;
        this.dialogTextEffect = null;
        AbstractDungeon.overlayMenu.showBlackScreen();
        for (AbstractCard c : this.coloredCards) {
            UnlockTracker.markCardAsSeen(c.cardID);
        }
        for (AbstractCard c : this.colorlessCards) {
            UnlockTracker.markCardAsSeen(c.cardID);
        }
        for (StoreRelic r : this.relics) {
            if (r.relic == null) continue;
            UnlockTracker.markRelicAsSeen(r.relic.relicId);
        }
    }

    public void update() {
        if (this.handTimer != 0.0f) {
            this.handTimer -= Gdx.graphics.getDeltaTime();
            if (this.handTimer < 0.0f) {
                this.handTimer = 0.0f;
            }
        }
        this.f_effect.update();
        this.somethingHovered = false;
        this.updatePurgeCard();
        this.updatePurge();
        this.updateRelics();
        this.updatePotions();
        this.updateRug();
        this.updateSpeech();
        this.updateCards();
        this.updateHand();
        AbstractCard hoveredCard = null;
        for (AbstractCard c : this.coloredCards) {
            if (!c.hb.hovered) continue;
            hoveredCard = c;
            this.somethingHovered = true;
            this.moveHand(c.current_x - AbstractCard.IMG_WIDTH / 2.0f, c.current_y);
            break;
        }
        for (AbstractCard c : this.colorlessCards) {
            if (!c.hb.hovered) continue;
            hoveredCard = c;
            this.somethingHovered = true;
            this.moveHand(c.current_x - AbstractCard.IMG_WIDTH / 2.0f, c.current_y);
            break;
        }
        if (!this.somethingHovered) {
            this.notHoveredTimer += Gdx.graphics.getDeltaTime();
            if (this.notHoveredTimer > 1.0f) {
                this.handTargetY = Settings.HEIGHT;
            }
        } else {
            this.notHoveredTimer = 0.0f;
        }
        if (hoveredCard != null && InputHelper.justClickedLeft) {
            hoveredCard.hb.clickStarted = true;
        }
        if (hoveredCard != null && InputHelper.justClickedRight) {
            CardCrawlGame.cardPopup.open(hoveredCard);
        }
        if (hoveredCard != null && hoveredCard.hb.clicked) {
            hoveredCard.hb.clicked = false;
            if (AbstractDungeon.player.gold >= hoveredCard.price) {
                CardCrawlGame.metricData.items_purchased.add(hoveredCard.cardID);
                this.coloredCards.remove(hoveredCard);
                this.colorlessCards.remove(hoveredCard);
                AbstractDungeon.topLevelEffects.add(new FastCardObtainEffect(hoveredCard, hoveredCard.current_x, hoveredCard.current_y));
                AbstractDungeon.player.loseGold(hoveredCard.price);
                CardCrawlGame.sound.play("SHOP_PURCHASE", 0.1f);
                if (AbstractDungeon.player.hasRelic("The Courier")) {
                    if (hoveredCard.color == AbstractCard.CardColor.COLORLESS) {
                        AbstractCard.CardRarity tempRarity = AbstractCard.CardRarity.UNCOMMON;
                        if (AbstractDungeon.merchantRng.random() < AbstractDungeon.colorlessRareChance) {
                            tempRarity = AbstractCard.CardRarity.RARE;
                        }
                        AbstractCard tmp = AbstractDungeon.getColorlessCardFromPool(tempRarity).makeCopy();
                        tmp.current_x = hoveredCard.current_x;
                        tmp.current_y = hoveredCard.current_y;
                        tmp.target_x = tmp.current_x;
                        tmp.target_y = tmp.current_y;
                        this.setPrice(tmp);
                        this.colorlessCards.add(tmp);
                    } else {
                        AbstractCard tmp = AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), hoveredCard.type, false).makeCopy();
                        tmp.current_x = hoveredCard.current_x;
                        tmp.current_y = hoveredCard.current_y;
                        tmp.target_x = tmp.current_x;
                        tmp.target_y = tmp.current_y;
                        this.setPrice(tmp);
                        this.coloredCards.add(tmp);
                    }
                }
                hoveredCard = null;
                InputHelper.justClickedLeft = false;
                this.notHoveredTimer = 1.0f;
                this.speechTimer = MathUtils.random(40.0f, 60.0f);
                this.playBuySfx();
                this.createSpeech(ShopScreen.getBuyMsg());
            } else {
                this.speechTimer = MathUtils.random(40.0f, 60.0f);
                this.playCantBuySfx();
                this.createSpeech(ShopScreen.getCantBuyMsg());
            }
        }
    }

    private void updateCards() {
        int i;
        for (i = 0; i < this.coloredCards.size(); ++i) {
            this.coloredCards.get(i).update();
            this.coloredCards.get(i).updateHoverLogic();
            this.coloredCards.get((int)i).target_y = this.coloredCards.get((int)i).current_y = this.rugY + TOP_ROW_Y;
        }
        for (i = 0; i < this.colorlessCards.size(); ++i) {
            this.colorlessCards.get(i).update();
            this.colorlessCards.get(i).updateHoverLogic();
            this.colorlessCards.get((int)i).target_y = this.colorlessCards.get((int)i).current_y = this.rugY + BOTTOM_ROW_Y;
        }
    }

    private void setPrice(AbstractCard card) {
        float tmpPrice = (float)AbstractCard.getPrice(card.rarity) * AbstractDungeon.merchantRng.random(0.9f, 1.1f);
        if (card.color == AbstractCard.CardColor.COLORLESS) {
            tmpPrice *= 1.3f;
        }
        if (AbstractDungeon.player.hasRelic("The Courier")) {
            tmpPrice *= 0.8f;
        }
        if (AbstractDungeon.player.hasRelic("Membership Card")) {
            tmpPrice *= 0.8f;
        }
        tmpPrice = MathUtils.round(tmpPrice * 1.25f);
        card.price = (int)tmpPrice;
    }

    public void moveHand(float x, float y) {
        this.handTargetX = x - 50.0f * Settings.scale;
        this.handTargetY = y + 90.0f * Settings.scale;
    }

    private void updatePurgeCard() {
        this.purgeCardX = 1554.0f * Settings.scale;
        this.purgeCardY = this.rugY + BOTTOM_ROW_Y;
        if (this.purgeAvailable) {
            float CARD_W = 110.0f * Settings.scale;
            float CARD_H = 150.0f * Settings.scale;
            if ((float)InputHelper.mX > this.purgeCardX - CARD_W && (float)InputHelper.mX < this.purgeCardX + CARD_W && (float)InputHelper.mY > this.purgeCardY - CARD_H && (float)InputHelper.mY < this.purgeCardY + CARD_H) {
                this.purgeHovered = true;
                this.moveHand(this.purgeCardX - AbstractCard.IMG_WIDTH / 2.0f, this.purgeCardY);
                this.somethingHovered = true;
                this.purgeCardScale = Settings.scale;
            } else {
                this.purgeHovered = false;
            }
            if (!this.purgeHovered) {
                this.purgeCardScale = MathHelper.cardScaleLerpSnap(this.purgeCardScale, 0.75f * Settings.scale);
            } else {
                if (InputHelper.justClickedLeft) {
                    this.purgeHovered = false;
                    if (AbstractDungeon.player.gold >= actualPurgeCost) {
                        ++CardCrawlGame.metricData.purchased_purges;
                        AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.SHOP;
                        AbstractDungeon.gridSelectScreen.open(CardGroup.getGroupWithoutBottledCards(AbstractDungeon.player.masterDeck.getPurgeableCards()), 1, NAMES[13], false, false, true, true);
                    } else {
                        this.playCantBuySfx();
                        this.createSpeech(ShopScreen.getCantBuyMsg());
                    }
                }
                TipHelper.renderGenericTip((float)InputHelper.mX - 360.0f * Settings.scale, (float)InputHelper.mY - 70.0f * Settings.scale, LABEL[0], MSG[0] + 25 + MSG[1]);
            }
        } else {
            this.purgeCardScale = MathHelper.cardScaleLerpSnap(this.purgeCardScale, 0.75f * Settings.scale);
        }
    }

    private void updateRelics() {
        for (StoreRelic r : this.relics) {
            r.update(this.rugY);
        }
    }

    private void updatePotions() {
        for (StorePotion p : this.potions) {
            p.update(this.rugY);
        }
    }

    public void createSpeech(String msg) {
        boolean isRight = MathUtils.randomBoolean();
        float x = MathUtils.random(660.0f, 1260.0f) * Settings.scale;
        float y = (float)Settings.HEIGHT - 380.0f * Settings.scale;
        this.speechBubble = new ShopSpeechBubble(x, y, 4.0f, msg, isRight);
        float offset_x = 0.0f;
        offset_x = isRight ? SPEECH_TEXT_R_X : SPEECH_TEXT_L_X;
        this.dialogTextEffect = new SpeechTextEffect(x + offset_x, y + SPEECH_TEXT_Y, 4.0f, msg, DialogWord.AppearEffect.BUMP_IN);
    }

    private void updateSpeech() {
        if (this.speechBubble != null) {
            this.speechBubble.update();
            if (this.speechBubble.hitbox.hovered && this.speechBubble.duration > 0.3f) {
                this.speechBubble.duration = 0.3f;
                this.dialogTextEffect.duration = 0.3f;
            }
            if (this.speechBubble.isDone) {
                this.speechBubble = null;
            }
        }
        if (this.dialogTextEffect != null) {
            this.dialogTextEffect.update();
            if (this.dialogTextEffect.isDone) {
                this.dialogTextEffect = null;
            }
        }
        this.speechTimer -= Gdx.graphics.getDeltaTime();
        if (this.speechBubble == null && this.dialogTextEffect == null && this.speechTimer <= 0.0f) {
            this.speechTimer = MathUtils.random(40.0f, 60.0f);
            if (!this.saidWelcome) {
                this.createSpeech(WELCOME_MSG);
                this.saidWelcome = true;
                this.welcomeSfx();
            } else {
                this.playMiscSfx();
                this.createSpeech(this.getIdleMsg());
            }
        }
    }

    private void welcomeSfx() {
        int roll = MathUtils.random(2);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_MERCHANT_3A");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_MERCHANT_3B");
        } else {
            CardCrawlGame.sound.play("VO_MERCHANT_3C");
        }
    }

    private void playMiscSfx() {
        int roll = MathUtils.random(5);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_MERCHANT_MA");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_MERCHANT_MB");
        } else if (roll == 2) {
            CardCrawlGame.sound.play("VO_MERCHANT_MC");
        } else if (roll == 3) {
            CardCrawlGame.sound.play("VO_MERCHANT_3A");
        } else if (roll == 4) {
            CardCrawlGame.sound.play("VO_MERCHANT_3B");
        } else {
            CardCrawlGame.sound.play("VO_MERCHANT_3C");
        }
    }

    public void playBuySfx() {
        int roll = MathUtils.random(2);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_MERCHANT_KA");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_MERCHANT_KB");
        } else {
            CardCrawlGame.sound.play("VO_MERCHANT_KC");
        }
    }

    public void playCantBuySfx() {
        int roll = MathUtils.random(2);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_MERCHANT_2A");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_MERCHANT_2B");
        } else {
            CardCrawlGame.sound.play("VO_MERCHANT_2C");
        }
    }

    private String getIdleMsg() {
        return this.idleMessages.get(MathUtils.random(this.idleMessages.size() - 1));
    }

    private void updateRug() {
        if (this.rugY != 0.0f) {
            this.rugY = MathUtils.lerp(this.rugY, 0.0f, Gdx.graphics.getDeltaTime() * 5.0f);
            if (Math.abs(this.rugY - 0.0f) < 0.5f) {
                this.rugY = 0.0f;
            }
        }
    }

    private void updateHand() {
        if (this.handTimer == 0.0f) {
            if (this.handX != this.handTargetX) {
                this.handX = MathUtils.lerp(this.handX, this.handTargetX, Gdx.graphics.getDeltaTime() * 6.0f);
            }
            if (this.handY != this.handTargetY) {
                this.handY = this.handY > this.handTargetY ? MathUtils.lerp(this.handY, this.handTargetY, Gdx.graphics.getDeltaTime() * 6.0f) : MathUtils.lerp(this.handY, this.handTargetY, Gdx.graphics.getDeltaTime() * 6.0f / 4.0f);
            }
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(this.rugImg, 0.0f, this.rugY, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        this.renderCardsAndPrices(sb);
        this.renderRelics(sb);
        this.renderPotions(sb);
        this.renderPurge(sb);
        sb.draw(this.handImg, this.handX + this.f_effect.x, this.handY + this.f_effect.y, HAND_W, HAND_H);
        if (this.speechBubble != null) {
            this.speechBubble.render(sb);
        }
        if (this.dialogTextEffect != null) {
            this.dialogTextEffect.render(sb);
        }
    }

    private void renderRelics(SpriteBatch sb) {
        for (StoreRelic r : this.relics) {
            r.render(sb);
        }
    }

    private void renderPotions(SpriteBatch sb) {
        for (StorePotion p : this.potions) {
            p.render(sb);
        }
    }

    private void renderCardsAndPrices(SpriteBatch sb) {
        Color color;
        for (AbstractCard c : this.coloredCards) {
            c.render(sb);
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.UI_GOLD, c.current_x + GOLD_IMG_OFFSET_X, c.current_y + GOLD_IMG_OFFSET_Y - (c.drawScale - 0.75f) * 200.0f * Settings.scale, GOLD_IMG_WIDTH, GOLD_IMG_WIDTH);
            color = Color.WHITE.cpy();
            if (c.price > AbstractDungeon.player.gold) {
                color = Color.SALMON.cpy();
            } else if (c.equals(this.saleTag.card)) {
                color = Color.SKY.cpy();
            }
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.tipHeaderFont, Integer.toString(c.price), c.current_x + PRICE_TEXT_OFFSET_X, c.current_y + PRICE_TEXT_OFFSET_Y - (c.drawScale - 0.75f) * 200.0f * Settings.scale, color);
        }
        for (AbstractCard c : this.colorlessCards) {
            c.render(sb);
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.UI_GOLD, c.current_x + GOLD_IMG_OFFSET_X, c.current_y + GOLD_IMG_OFFSET_Y - (c.drawScale - 0.75f) * 200.0f * Settings.scale, GOLD_IMG_WIDTH, GOLD_IMG_WIDTH);
            color = Color.WHITE.cpy();
            if (c.price > AbstractDungeon.player.gold) {
                color = Color.SALMON.cpy();
            } else if (c.equals(this.saleTag.card)) {
                color = Color.SKY.cpy();
            }
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.tipHeaderFont, Integer.toString(c.price), c.current_x + PRICE_TEXT_OFFSET_X, c.current_y + PRICE_TEXT_OFFSET_Y - (c.drawScale - 0.75f) * 200.0f * Settings.scale, color);
        }
        if (this.coloredCards.contains(this.saleTag.card)) {
            this.saleTag.render(sb);
        }
        if (this.colorlessCards.contains(this.saleTag.card)) {
            this.saleTag.render(sb);
        }
        for (AbstractCard c : this.coloredCards) {
            c.renderCardTip(sb);
        }
        for (AbstractCard c : this.colorlessCards) {
            c.renderCardTip(sb);
        }
    }

    private void renderPurge(SpriteBatch sb) {
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
        sb.draw(ImageMaster.CARD_SKILL_BG_SILHOUETTE, this.purgeCardX - 256.0f + 18.0f * Settings.scale, this.purgeCardY - 256.0f - 14.0f * Settings.scale, 256.0f, 256.0f, 512.0f, 512.0f, this.purgeCardScale, this.purgeCardScale, 0.0f, 0, 0, 512, 512, false, false);
        sb.setColor(Color.WHITE);
        if (this.purgeAvailable) {
            sb.draw(ImageMaster.PURGE_CARD_IMG, this.purgeCardX - 256.0f, this.purgeCardY - 256.0f, 256.0f, 256.0f, 512.0f, 512.0f, this.purgeCardScale, this.purgeCardScale, 0.0f, 0, 0, 512, 512, false, false);
            sb.draw(ImageMaster.UI_GOLD, this.purgeCardX + GOLD_IMG_OFFSET_X, this.purgeCardY + GOLD_IMG_OFFSET_Y - (this.purgeCardScale / Settings.scale - 0.75f) * 200.0f * Settings.scale, GOLD_IMG_WIDTH, GOLD_IMG_WIDTH);
            Color color = Color.WHITE;
            if (actualPurgeCost > AbstractDungeon.player.gold) {
                color = Color.SALMON;
            }
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.tipHeaderFont, Integer.toString(actualPurgeCost), this.purgeCardX + PRICE_TEXT_OFFSET_X, this.purgeCardY + PRICE_TEXT_OFFSET_Y - (this.purgeCardScale / Settings.scale - 0.75f) * 200.0f * Settings.scale, color);
        } else {
            sb.draw(ImageMaster.SOLD_OUT_IMG, this.purgeCardX - 256.0f, this.purgeCardY - 256.0f, 256.0f, 256.0f, 512.0f, 512.0f, this.purgeCardScale, this.purgeCardScale, 0.0f, 0, 0, 512, 512, false, false);
        }
    }

    static {
        GOLD_IMG_WIDTH = (float)ImageMaster.UI_GOLD.getWidth() * Settings.scale;
        GOLD_IMG_OFFSET_X = -50.0f * Settings.scale;
        GOLD_IMG_OFFSET_Y = -215.0f * Settings.scale;
        PRICE_TEXT_OFFSET_X = 16.0f * Settings.scale;
        PRICE_TEXT_OFFSET_Y = -180.0f * Settings.scale;
    }
}

